class Ex2_9
// determination of heat transferred
parameter Real k (unit = "")=136; // thermal conductivity of aluminium in BTU/(hr.ft.degree Rankine)from appendix table B1
parameter Real L (unit = "feet")=9/(8*12); //Length in feet.
parameter Real W (unit = "feet")=9/(4*12); //Width in feet.
parameter Real delta (unit = "feet")=1/(32*12);
parameter Real hc (unit = "BTU/(hr.ft^2. degree Rankine)")=0.8; // the convective heat transfer coefficient estimated as 1 BTU/(hr.ft^2. degree Rankine)
parameter Real T_w (unit = "°F")=1000;// the root temperature in degree fahrenheit
parameter Real T_inf (unit = "°F")=90; // the ambient temperature in degree fahrenheit
parameter Real m (unit = "lb")=sqrt(hc/(k*delta));
parameter Real P (unit = "feet")=2*W;
parameter Real A (unit = "feet^2")=2*delta*W;
parameter Real Lc (unit = "feet")=L+delta;
Real qz1 (unit = "BTU/hr"); //Heat transferred in case 1.
Real qz2 (unit = "BTU/hr"); //Heat transferred in case 2.
Real qz3 (unit = "BTU/hr");  //Heat transferred in case 3.
equation
qz1=sqrt(hc*P*k*A)*(T_w-T_inf)*(sinh(m*L)+(hc/(m*k)*cosh(m*L)))/(cosh(m*L)+(hc/(m*k)*sinh(m*L)));
qz2=sqrt(k*A*hc*P)*(T_w-T_inf)*tanh(m*L);
qz3=k*A*m*(T_w-T_inf)*tanh(m*L*(1+delta/Lc)); 
end Ex2_9;