class Ex3_4
import Modelica.Math.*;
parameter Real OD (unit = "ft")=4.5/12; // diameter in ft
parameter Real R (unit = "ft")=OD/2;
// For pipe A
parameter Real L_A (unit = "ft")=4.5; // length in ft
// shape factor number 9 is selected from table 3.1
Real S_A;//The Shape Factor of pipe A
// For pipe B
parameter Real L_B (unit = "ft")=18; // length in ft
Real S_B;//The Shape Factor of pipe B
Real S;//The total conduction shape factor for the system
equation
S_A=(2*3.1412*L_A)/(log(2*(L_A)/R));
S_B=(2*3.1412*L_B)/(acosh(L_A/R));
S=2*S_A+S_B;
end Ex3_4;