class Ex4_1
import Modelica.SIunits.*;
parameter Real k=12; // thermal conductivity in BTU/(hr.ft.degree Rankine) 
parameter Real c=0.1; // specific heat in BTU/(lbm.degree Rankine) 
parameter Real D=0.025/12; // diameter in ft
parameter Real density=525; // density in lbm/cu.ft
parameter Real hc=80; // convective coefficient in BTU/(hr. sq.ft. degree Rankine)
parameter Real T_i=65; // intial temperature in degree fahrenheit
parameter Real T_inf=140; // fluid temperature in degree fahrenheit
Real As; // surface area in sq.ft
Real Vs; // volume in cu.ft
Real T_inv;//The reciprocal of time constant
parameter Real T=139;
Time t;//The response time of the junction
equation
As =3.14*D^2;
Vs=3.14*D^3/6;
T_inv=(hc*As)/(density*Vs*c);
t =(log((T-T_inf)/(T_i-T_inf))/(-T_inv))*3600;
end Ex4_1;