class Ex6_2
parameter Real Tbo  (unit = "°F")=140;// bulk-fluid outlet temperature in Fahrenheit
parameter Real Tbi (unit = "°F")=70;// bulk-fluid inlet temperature in Fahrenheit
parameter Real T_avg (unit = "°F")=(Tbo+Tbi)/2;//Avg temp. in Fahrenheit
// properties of water at average bulk temperature from appendix table C11
parameter Real rho (unit = "lb/ft^3")=62;//Density of  water at average bulk temperature
parameter Real  kf (unit = "BTU/(hr.ft.°Rankine)")=0.363;//Thermal conductivity water at average bulk temperature
parameter Real  cp (unit = "BTU/(lbm.°R)")=0.9980;//Specific heat of water at average bulk temperature
parameter Real  a (unit = "ft^2/hr")=5.86e-3;//Thermal diffusivity of water at average bulk temperature
parameter Real  v (unit = "(ft2/s)")=0.708e-5;//Kinematic Viscosity  of water at average bulk temperature
parameter Real Pr=4.34;//Prandtl number of water at average bulk temperature
// specifications of 1 standard type M copper tube from appendix table F2
parameter Real OD (unit = "in")=1.125; // outer diameter in in
parameter Real ID (unit = "feet")=0.8792; // inner diameter in ft
parameter Real A (unit = "feet^2")=0.006071; // cross sectional area in sq.ft
parameter Real m_flow (unit = "lbm/s")= 1.5; // mass flow rate in lbm/s
Real V (unit = "ft/hr"); // velocity in ft/hr
parameter Real L (unit = "feet")=20;//Length of exchanger in ft.
parameter Real Tw (unit = "°F")=240;//Steam saturation and condensation temperature
Real hL (unit = "BTU/(hr. sq.ft.°Rankine)");//The average convective coeff in BTU/(hr. sq.ft.degree Rankine)
algorithm
V:=m_flow*3600/(rho*A);
hL:=-(rho*V*ID*cp*log((Tw-Tbo)/(Tw-Tbi)))/(4*L);//Error in the textbook.
end Ex6_2;