class Ex6_4
//System is throwing an error for no conceivable reason
// properties of Freon-12 at average bulk temperature
parameter Real kf (unit = "BTU/(hr.ft.°R) ")=0.04; // thermal conductivity in BTU/(hr.ft.°R) 
parameter Real cp (unit = "BTU/(lbm-°R)")=0.2139; // specific heat in BTU/(lbm-°R)
parameter Real rho (unit = "lbm/cu.ft")= 1.489*(62.4); // density in lbm/cu.ft
parameter Real v (unit = "sq.ft/s")=0.272e-5; // viscosity in sq.ft/s
parameter Real a (unit = "sq.ft/hr")=2.04e-3; // diffusivity in sq.ft/hr
parameter Real Pr=4.8; // Prandtl Number
// specifications of 3/8 standard type K copper tubing from appendix table F2
parameter Real OD (unit = "ft")=0.5/12; // outer diameter in ft
parameter Real ID (unit = "ft")=0.03350; // inner diameter in ft
parameter Real A (unit = "sq.ft")=0.0008814; // cross sectional area in sq.ft
// Laminar conditions are asssumed
parameter Real z=5;
parameter Real Tw (unit = "°F")=32;//Operational temp
parameter Real Tbo (unit = "°F")=-4;//The bulk-fluid outlet temperature
parameter Real Tbi (unit = "°F")=-40;//The bulk-fluid inlet temperature
parameter Real L (unit = "feet")=5;// Length of copper tube
Real[6] V_assumed (unit = ""); //assumed value for velocity
parameter Real[6] Nu={4.7, 5.8, 6.2, 6.3, 6.4, 6.4}; // corresponding Nusselt numbers from fig. 6.8: 
Real[6] inv_Gz;
Real[6] hL (unit = "BTU/(hr. sq.ft.°Rankine)");//The convective coeff in BTU/(hr. sq.ft.°Rankine)
Real[6] V (unit = "ft/hr");//The velocity in ft/hr 
Real V_final (unit = "ft/s");//The final velocity in ft/s

Real hL_final (unit = "BTU/(hr. sq.ft. °R)");//The final convective coefficient in BTU/(hr. sq.ft. °R)
// checking the laminar-flow assumption by calculating the Reynolds number
Real Re;//The Reynolds number 
Real m_Fr (unit = "lbm/s");//The mass flow rate of Freon-12 in lbm/s
Real As (unit = "ft^2");
Real q (unit = "BTU/hr");//The heat gained by Freon-12 in BTU/hr
Real q_check (unit = "BTU/hr");
//On checking the heat transferred we find almost equal to the heat gained by Freon-12");
parameter Real rho_water (unit = "lbm/ft^3")=1.002*62.4; //water density in lbm/ft^3 from appendix table C11
Real m_water (unit = "lbm");//The mass of water in the prescribed volume in lbm
Real t (unit = "hr");//The required time to remove 144 BTU/lbm of water
parameter Real[6] inv_Gz1={0.001, 0.004, 0.01, 0.015, 0.02, 0.0271}; // guess values of 1/Gz
parameter Real[6] Nu_D={19.3, 12.1, 8.9, 7.7, 7.1, 6.4}; //corresponding Nusselt number from fig. 6.8
Real[6] Z;
Real[6] hz (unit = "BTU/(hr. sq.ft.°Rankine)");
Real[6] Tbz (unit = "°F");
algorithm
V_assumed := {100.0,246,304,325,330,336};
for i in 1:6 loop
    inv_Gz[i]:=(z*a)/(V_assumed[i]*ID^2);
    hL[i]:=Nu[i]*kf/ID;
    V[i]:=-(2*a*L*hL[i])/((kf*ID/2)*log((Tw-Tbo)/(Tw-Tbi)));
 
end for;

V_final:=V[6];

hL_final:=hL[6];
Re:=(V_final/3600)*ID/v;
m_Fr:=rho*A*V_final/3600;
As:=3.1412*ID*L;
q:=hL_final*As*((Tw-Tbo)-(Tw-Tbi))/(log((Tw-Tbo)/(Tw-Tbi)));
q_check:=m_Fr*cp*(Tbo-Tbi);
m_water:=rho_water*L*(2/12)*(3/12);
t:=144*m_water/q;
for j in 1:6 loop 
    Z[j]:=ID*Re*Pr*(inv_Gz1[j]);   
    hz[j]:=Nu_D[j]*kf/ID;
    Tbz[j]:=32-72*exp(-0.01812*Z[j]*hz[j]);
end for;
end Ex6_4;