class Ex6_5
import Modelica.SIunits.*;
// The liquid properties are evaluated at the mean temperature of (80 + 20)/2 = 50°C.
// specifications of 1 standard type K copper water tubing from appendix table F2
parameter Length OD = 2.858/100; // outer diameter in m 
parameter Length ID = 2.528/100; // inner diameter in m 
parameter Area A = 5.019e-4; // cross sectional area in sq.m
// 1 oz = 2.957e-5 m^3
parameter  VolumeFlowRate Q=80*(2.957e-5)/120; // The volume flow rate of water (at 20°C) in cu.m/s
parameter Density p_20= 1.000*1000; // density of water at 20°C in kg/cu.m
// properties of water at 50°C from appendix table C11
parameter Density p_50= 0.990*(1000); // density in kg/m3 
parameter SpecificHeatCapacity cp= 4181; // specific heat in J/(kg*K) 
parameter KinematicViscosity v = 0.586e-6; // viscosity in sq.m/s 
parameter ThermalConductivity kf = 0.640; // thermal conductivity in W/(m.K) 
parameter ThermalDiffusivity a = 1.533e-7; // diffusivity in sq.m/s 
parameter Real Pr = 3.68; // Prandtl number
MassFlowRate mass_flow; // mass flow rate through the tube in kg/s
parameter Length L=3; //  length of tube in m
Area As;
parameter Temperature Tbo=80+273.15; // final temperature in K
parameter Temperature Tbi=20+273.15; // initial temperature in K
HeatFlux qw;//Power flux  
Power q;//The power required
Area A2;
Velocity V; // average velocity at 50 °C
Real Re; // Reynold's Number
// The flow is laminar so we can use  Figure 6.12 to obtain the information needed on Nusselt number and to find hz
Real inv_Gz; // The inverse Graetz number at tube end, based on 50°C conditions
Real Nu=6.9; //value of corresponding Nusselts Number from figure 6.12
CoefficientOfHeatTransfer hz;//The local convection coefficient
Temperature Two; // The outlet wall temperature in K
equation
mass_flow=p_20*Q;
As=3.1412*ID*L;
qw=mass_flow*cp*(Tbo-Tbi)/(As);
q=qw*As;
A2=3.1412*(ID/2)^2;
V=mass_flow/(p_50*A);
Re=(V*ID)/v; 
inv_Gz=L/(Re*ID*Pr);
hz=(Nu*kf)/ID;
Two=(qw/hz)+Tbo;
end Ex6_5;