class Ex7_1
import Modelica.SIunits.*;
// determination of boundary layer growth with length
// properties of air at 27 degree celsius from appendix table D.1
parameter Density rho=1.177; // density in kg/cu.m
parameter KinematicViscosity v=15.68e-6; // viscosity in sq.m/s
parameter Length L=0.5; // length in m
parameter Velocity V_inf=1; // air velocity in m/s
Real Re; // Reynolds Number
// Reynolds Number is less than 5e5 hence the flow is laminar and Blasius Solution applies
parameter Length[5] x={0, 0.125, 0.25, 0.375, 0.5}; // distances in m where boundary layer growth is determined
Real[5] delta;
parameter Length[6] eta=0:5; //Distance at which velocity distribution has to be found 
Real[6] f={0, 0.32979, 0.62977, 0.84605, 0.95552, 0.99155};//value for f for corresponding eta value from Table 7.1
Real[6] y;
parameter Real gc=1;
DynamicViscosity mu;//The absolute viscosity in N.s/sq.m
parameter Length b=1; // width in m
Force Df;//The skin-drag in N
Force Plate_Df;//Skin drag for both sides of plate
equation
Re= (V_inf*L)/v;
for i in 1:5 loop
    delta[i]=5*x[i]^0.5/(V_inf/v)^0.5;
end for;
for j in 1:6 loop
    y[j]=eta[j]*(v*0.25)^0.5;
end for;
mu=rho*v/gc;
Df=0.664*V_inf*mu*b*(Re)^0.5;
Plate_Df = 2*Df;
end Ex7_1;