class Ex7_4
//  Determination of the maximum heater-surface temperature for given conditions
// fluid properties at (300 degree R + 800 degree R)/2 = 550 degree R=540degree R from Appendix Table D.6
parameter Real rho (unit = "lbm/ft^3")= 0.0812; // density in lbm/ft^3 
parameter Real cp (unit = "BTU/(lbm-°R)")=0.2918; // specific heat in BTU/(lbm-°R) 
parameter Real v (unit = "ft^2/s")= 17.07e-5; // viscosity in ft^2/s 
parameter Real kf (unit = "BTU/(hr.ft.°R)") = 0.01546 ; // thermal conductivity in BTU/(hr.ft.°R) 
parameter Real a (unit = "ft^2/hr") = 0.8862; // diffusivity in ft^2/hr 
parameter Real Pr = 0.709; // Prandtl Number
Real qw (unit = "BTU/ft^2"); // The wall flux 
parameter Real V_inf (unit = "ft/s")=20; // velocity in ft/s
parameter Real L (unit = "ft")=1.5/12; // length in ft
Real Re_L; // Reynolds number at plate end
// So the flow is laminar and we can find the wall temperature at plate end as follows
parameter Real T_inf (unit = "°R")=300; // free stream temperature in degree Rankine
Real Tw (unit = "°R");//The maximum heater surface temperature in degree Rankine

equation
qw=10/(1.5*10.125)*(1/cp)*144;
Re_L=V_inf*10*L/v;
Tw=T_inf+(qw*L*10/(kf*0.453*(Re_L)^0.5*(Pr)^(1/3)));
end Ex7_4;