class Ex7_5
// validation of the equation st.(Pr)^(2/3)=Cd/2 where St: Stanton Number Pr:Prandtl Number Cd: Drag Coefficient
// values of parameters from example 7.4
parameter Real rho (unit = "lbm/ft^3")= 0.0812; // density in lbm/ft^3 
parameter Real cp (unit = "BTU/(lbm-°R)")=0.2918; // specific heat BTU/(lbm-°R) 
parameter Real v (unit = "ft^2/s")= 17.07e-5; // viscosity in ft^2/s 
parameter Real kf (unit = "BTU/(hr.ft.°R)") = 0.01546 ; // thermal conductivity in BTU/(hr.ft.°R) 
parameter Real a (unit = "ft^2/hr") = 0.8862; // diffusivity in ft^2/hr 
parameter Real Pr = 0.709; // Prandtl Number
parameter Real Tw (unit = "°R")=469; // maximum heater temperature in °R
parameter Real T_inf (unit = "°R")=300; // free-stream temperature in °R
parameter Real qw (unit = "BTU/(hr.ft^2)")=324; // The wall flux in BTU/(hr.ft^2)
parameter Real V_inf (unit = "ft/s")=20; // velocity in ft/s
Real hx (unit = "BTU/(hr.sq.ft.°R)"); //  The convection coefficient in BTU/(hr.sq.ft.°R)
Real LHS;//LHS of the equation
Real Re_L=1.46e+005; // Reynolds number at plate end
Real RHS;//RHS of the equation
Real err;//The error
equation
hx=qw/(Tw-T_inf);
LHS=(hx/3600)*(Pr)^(2/3)/(rho*cp*V_inf);
RHS=0.332*(Re_L)^(-0.5);
err=(LHS-RHS)*100/LHS;
end Ex7_5;