class Ex7_9
import Modelica.SIunits.*;

// determination of required current
// properties of air at film temperature (300 + 500)/2 = 400 K from appendix table D1
parameter Density rho= 0.883; // density in kg/cu.m
parameter SpecificHeatCapacity cp= 1014; // specific heat in J/(kg*K) 
parameter KinematicViscosity v= 25.90e-6; // viscosity in sq.m/s  
parameter Real Pr = 0.689; // Prandtl Number 
parameter ThermalConductivity kf= 0.03365; // thermal conductivity in W/(m.K)
parameter ThermalDiffusivity a = 0.376e-4; // diffusivity in sq.m/s
parameter Velocity V_inf=1; // velocity in m/s
parameter Length D=0.00013; // diameter in m
parameter Length L=1/100; // length of wire in m
Real Re_D; // The Reynolds number of flow past the wire
parameter Real C=0.911; //value of C for cylinder from table 7.4
parameter Real m=0.385; //value of m for cylinder from table 7.4
CoefficientOfHeatTransfer hc; // the convection coefficient in W/(m^2.K)
parameter Temperature Tw=500; // air stream temperature in K
parameter Temperature T_inf=300; // wire surface temperature in K
Area As; // cross sectional area in sq.m
Power qw; // The heat transferred to the air from the wire in watts
parameter Resistivity resistivity=17e-8; // resistivity in ohm m
Resistance resistance; // resistance in ohm
//printf("\nThe resistance is %.3f ohm",Resistance/100);
ElectricCurrent I; // current in ampere
equation
Re_D=V_inf*D/v;
hc=kf*C*(Re_D)^m*(Pr)^(1/3)/D;
As=3.1412*D*L;
qw=hc*As*(Tw-T_inf);
resistance=resistivity*(L/(3.1412*D^2));
I=(qw/resistance)^0.5;
end Ex7_9;