class Ex8_8
import Modelica.SIunits.*;
// determination of the maximum  amount of heat that fins can transfer
// properties of air at (100 + 35)/2 = 67.5 degree C from appendix table D1
parameter Density rho= 0.998; // density in kg/cu.m
parameter SpecificHeatCapacity cp= 1009.0; // specific heat in J/(kg*K) 
parameter KinematicViscosity v= 20.76e-6; // viscosity in sq.m/s  
parameter Real Pr =0.697; // Prandtl Number 
parameter ThermalConductivity kf= 0.03003; // thermal conductivity in W/(m.K)
parameter ThermalDiffusivity a = 0.2983e-4; // diffusivity in sq.m/s 
parameter Acceleration g=9.81;//Gravitational acceleration in m/s^2
parameter Temperature T_inf=35+273.15; // ambient air temperature in K
parameter Temperature Tw=100+273.15; // surface temperature in K
CubicExpansionCoefficient Beta; // volumetric thermal expansion coefficient in per K
// properties of aluminium from appendix table B1
parameter Density rho_Al=2702; // density in kg/cu.m
parameter ThermalConductivity k_Al=236; // thermal conductivity in W/(m.K)
parameter SpecificHeatCapacity cp_Al=896;// specific heat in J/(kg*K) 
parameter ThermalDiffusivity a_Al=97.5e-6; // diffusivity in sq.m/s 
parameter Length b=46/100;//The breadth of the fin
parameter Length w=24/100;//The width of the fin
// Applying the Bar-Cohen Equations
Length zeta;
Length L;//The fin length in m
Length S;//The fin spacing in m
Power q;//The heat transfer rate in W
Real N;//Approx. number of fins

equation
Beta=1/(T_inf);
zeta=((w*v^2)/(g*Beta*(Tw-T_inf)*Pr))^(1/4);
L=1.54*(k_Al/kf)^(1/2)*zeta;
S=2.89*zeta;
q=(b*w*(Tw-T_inf)*1.3*(k_Al*kf)^(1/2))/(6*zeta);
N=b/(2*S);
end Ex8_8;