class Ex9_1
import Modelica.SIunits.*;
// determination of counterflow and parallel-flow configurations. 
// temperatures of hot fluid in K
parameter Temperature T1=100+273.15;//Temperature of hot fluid in K;
parameter Temperature T2=75+273.15;//Temperature of hot fluid in K
// temperatures of cold fluid in degree C
parameter Temperature t1=5+273.15;//Temperature of cold fluid in K;
parameter Temperature t2=50+273.15;//Temperature of cold fluid in K;
// for counterflow
Temperature LMTD_counter;//The LMTD for counter flow configuration in K
// for parallel flow
Temperature LMTD_parallel;//The LMTD for parallel flow configuration in K

equation
LMTD_counter=((T1-t2)-(T2-t1))/(log((T1-t2)/(T2-t1))) + 273.15;
LMTD_parallel=((T1-t1)-(T2-t2))/(log((T1-t1)/(T2-t2))) + 273.15;
end Ex9_1;