class Ex9_3
//  Determination of the  outlet  temperature of the ethylene glycol  for counterflow.
// properties of air at (195 + 85)/2 = 140°F. from appendix table CII
parameter Real rho_1 (unit="lbm/ft^3")= 0.985*62.4; // density in lbm/ft^3 
parameter Real cp_1 (unit="BTU/(lbm-degree Rankine) ")=0.9994; // specific heat in BTU/(lbm-degree Rankine) 
parameter Real v_1 (unit="ft^2/s")= 0.514e-5; // viscosity in ft^2/s 
parameter Real kf_1 (unit="BTU/(hr.ft.degree Rankine)") = 0.376 ; // thermal conductivity in BTU/(hr.ft.degree Rankine) 
parameter Real a_1 (unit="ft^2/hr") = 6.02e-3; // diffusivity in ft^2/hr 
parameter Real Pr_1 = 3.02; // Prandtl Number 
parameter Real m_1 (unit="lbm/hr")=5000; // mass flow rate in lbm/hr
parameter Real T_1 (unit="degree F")=195; // temperature in degree F
// properties of ethylene glycol at 140 degree F from Appendix Table C.5
parameter Real rho_2 (unit="lbm/ft^3")= 1.087*62.4; // density in lbm/ft^3 
parameter Real cp_2 (unit="BTU/(lbm-degree Rankine)")=0.612; // specific heat in BTU/(lbm-degree Rankine) 
parameter Real v_2 (unit="ft^2/s")= 5.11e-5; // viscosity in ft^2/s 
parameter Real kf_2  (unit="BTU/(hr.ft.degree Rankine)")= 0.150 ; // thermal conductivity in BTU/(hr.ft.degree Rankine) 
parameter Real a_2  (unit="ft^2/hr")= 3.61e-3; // diffusivity in ft^2/hr 
parameter Real Pr_2 = 51; // Prandtl Number 
parameter Real m_2 (unit="lbm/hr")=12000; // mass flow rate in lbm/hr
parameter Real T_2 (unit="degree F")=85; // temperature in degree F
// specifications of seamless copper  water tubing  (subscripts: a = annulus, p = inner pipe or tube) from appendix table F2
parameter Real ID_a (unit="ft")=0.1674;
parameter Real ID_p (unit="ft")=0.1076;
parameter Real OD_p (unit="ft")=1.375/12;
// Flow Areas
Real A_p (unit="sq.ft");//The area of inner pipe in sq.ft
Real A_a (unit="sq.ft");//area of annulus in sq.ft

// Annulus Equivalent Diameters
Real D_h (unit="ft");//The Annulus Equivalent Diameter for friction in ft
Real D_e (unit="ft");//The Annulus Equivalent Diameter for heat transfer in ft

// Reynolds Numbers 
Real Re_1;//The Reynolds Number for water
Real Re_2;//The Reynolds Number for ethylene glycol
// Nusselt numbers
Real Nu_1;//The Nusselt number for water
Real Nu_2;//The Nusselt number for ethylene glycol
// Convection Coefficients 
Real h_1i (unit="BTU/(hr.ft^2.degree R)");//The convective coefficient for water based on inner diameter in BTU/(hr.ft^2.degree R)
Real h_1o (unit="BTU/(hr.sq.ft.degree R)");//The convective coefficient for water based on outer diameter in BTU/(hr.sq.ft.degree R)
Real h_2 (unit="BTU/(hr.sq.ft.degree R)");//The convective coefficient for ethylene glycol in BTU/(hr.sq.ft.degree R)
// Exchanger Coefficient 
Real Uo (unit="BTU/(hr.sq.ft.degree R)");//The overall exchanger coefficient in BTU/(hr.sq.ft.degree R)
Real R;//The ratio
parameter Real L (unit="ft")=20 ;//Length in feet
Real A (unit="sq.ft");//Area in sq.ft
parameter Real T1 (unit="degree F")=195;
parameter Real t1 (unit="degree F")=85;
Real T2 (unit="degree F");//The temperature T2 in degree F
Real t2 (unit="degree F");//The outlet temperature of Ethylene glycol in degree F

equation
A_p=3.1412*ID_p^2/4;
A_a=3.1412*((ID_a)^2-(OD_p)^2)/4;
D_h=ID_a-OD_p;
D_e=(ID_a^2-OD_p^2)/(OD_p);
Re_1=(m_1/3600)*(ID_p)/(v_1*rho_1*A_p);
Re_2=(m_2/3600)*(D_e)/(v_2*rho_2*A_a);
Nu_1=0.023*(Re_1)^(4/5)*(Pr_1)^0.3;
Nu_2=0.023*(Re_2)^(4/5)*(Pr_2)^0.4;
h_1i=Nu_1*kf_1/ID_p;
h_1o=h_1i*ID_p/OD_p;
h_2=Nu_2*kf_2/D_e;
Uo=1/((1/h_1o)+(1/h_2));
R=(m_2*cp_2)/(m_1*cp_1);
A=3.1412*OD_p*L;
T2=((T1*(R-1))-(R*t1*(1-exp((Uo*A*(R-1))/(m_2*cp_2)))))/(R*exp(Uo*A*(R-1)/(m_2*cp_2))-1);
t2=t1+(T1-T2)/R;
end Ex9_3;