class Ex9_6
// Using the effectiveness-NTU method to calculate the outlet temperatures of the fluids
// Data from Example 9.5
// properties of (distilled) water at 104°F 
parameter Real m_1 (unit = "lbm/hr")=170000; // mass flow rate in lbm/hr
parameter Real T1 (unit = "degree F")=110; // temperature in degree F
parameter Real cp_1 (unit = "BTU/(lbm-degree Rankine)")=0.998; // specific heat in BTU/(lbm-degree Rankine) 
// properties of (raw) water at 68°F 
parameter Real m_2 (unit = "lbm/hr")=150000; // mass flow rate in lbm/hr
parameter Real t1 (unit = "degree F")=65; // temperature in degree F
parameter Real cp_2 (unit = "BTU/(lbm-degree Rankine) ")=0.9988; // specific heat in BTU/(lbm-degree Rankine) 
parameter Real Uo (unit = "BTU/(hr.sq.ft.degree R)")=350; // exchanger coefficient in BTU/(hr.sq.ft.degree R)
parameter Real Ao (unit = "sq. ft")=703.7;//Exchanger area in sq. ft
// The effectiveness-NTU approach is used  when the overall heat transfer coefficient is known
// determining the capacitances
Real mcp_raw (unit = "BTU/(hr. degree R)");//The capacitance value of raw water in BTU/(hr. degree R)
Real mcp_distilled (unit = "BTU/(hr. degree R)");//The capacitance value of distilled water in BTU/(hr. degree R)
Real mcp_max (unit = "BTU/(hr. degree R)");//The max. capacitance value in BTU/(hr. degree R)
Real mcp_min (unit = "BTU/(hr. degree R)");//The min. capacitance value in BTU/(hr. degree R)

// determination of parameters for determining effectiveness
Real mcp_min_max;//Ratio of max. and min. capacitances
Real UA_mcpmin;//(UoAo)/(mcp_min)
parameter Real effectiveness=0.58; //value of effectiveness from figure 9.15 corresponding to the above calculated values of capacitance ratio and (UoAo/mcp_min)
Real qmax (unit = "BTU/hr");//The maximum heat transfer in BTU/hr
Real q (unit = "BTU/hr"); // actual heat transfer in BTU/hr
Real t2 (unit = "degree F");//Outlet temperatures for Raw Water in degree F
Real T2 (unit = "degree F");//Outlet temperatures for distilled Water in degree F

equation
mcp_raw=m_2*cp_2;
mcp_distilled=m_1*cp_1;
if mcp_raw>mcp_distilled then
    mcp_max=mcp_raw;
    mcp_min=mcp_distilled;
else 
    mcp_max=mcp_distilled;
    mcp_min=mcp_raw;
end if;
mcp_min_max=mcp_min/mcp_max;
UA_mcpmin=(Uo*Ao)/(mcp_min);
qmax=mcp_min*(T1-t1);
q=effectiveness*qmax;
t2=(q/mcp_raw)+t1;
T2=T1-(q/mcp_distilled);
end Ex9_6;