class Ex1_8

parameter Real k (unit = "[BTU/(hr.ft.degree Rankine)]")=0.604; // [BTU/(hr.ft.degree Rankine)]
parameter Real hc (unit = "BTU/(hr.ft^2.degree Rankine)")=3; // average value for natural convection in BTU/(hr.ft^2.degree Rankine)
parameter Real ew=0.93;//Emissivity
parameter Real f_wr=1; // shape factor
parameter Real sigma (unit = "BTU/(hr.ft^2.degree Rankine)")= 0.1714*10^(-8); // Stefan Boltzman's constant in BTU/(hr.ft^2.degree Rankine)
parameter Real L (unit = "ft")=4/12; // length in ft
parameter Real T1 (unit = "degree Rankine")=80+460; // temperature of side-walk in degree Rankine
parameter Real T_inf (unit = "degree Rankine")=20+460; // temperature of ambient air in degree Rankine
parameter Real T_r (unit = "degree Rankine")=0; // assuming space temperature to be 0 degree Rankine
parameter Real[5] Tw (unit = "degree Rankine")={470,480,490,485,484.5};
Real a;
Real b;
Real c;
Real[5] LHS;
// LHS of the form a*Tw+b*Tw^4=c
equation
a=((k/L)+hc);
b=(sigma*ew*f_wr);
c=(k*T1/L)+(hc*T_inf)+(sigma*f_wr*ew*T_r^4);
algorithm   
for i in 1:5 loop
    LHS[i]:=a*Tw[i]+b*Tw[i]^4;
end for;

end Ex1_8;