class Ex10_1
// Calculation of the heat-transfer rate and the amount of steam condensed
// properties of engine oil at (328 + 325)/2 = 326.5 degree F = 320°F from appendix table C11
parameter Real rho_f (unit = "lbm/ft^3")= 0.909*62.4; // density in lbm/ft^3 
parameter Real cp (unit = "BTU/(lbm-degree Rankine)")=1.037; // specific heat BTU/(lbm-degree Rankine) 
parameter Real v_f (unit = "ft^2/s")= 0.204e-5; // viscosity in ft^2/s 
parameter Real kf (unit = "BTU/(lbm.ft.degree Rankine)") = 0.393; // thermal conductivity in BTU/(lbm.ft.degree Rankine) 
parameter Real a (unit = "ft^2/hr") = 6.70e-3; // diffusivity in ft^2/hr 
parameter Real Pr = 1.099; // Prandtl Number 
parameter Real V_v (unit = "ft^3/lbm")=4.937; // specific volume in ft^3/lbm from superheated steam tables
Real rho_v; // vapour density
parameter Real g (unit = "ft/s^2")=32.2;
parameter Real hfg (unit = "BTU/(hr.ft2.°R")=888.8; // from saturated steam tables
parameter Real Tg (unit = "°F")=327.81;
parameter Real Tw (unit = "°F")=325;
parameter Real L (unit = "ft")=2; // length in ft
parameter Real W (unit = "ft")=3; // width in ft
parameter Real[10] z (unit = "ft")=0.2:0.2:2; // distance from entry of plate in ft
Real[10] delta (unit = "");//Growth of the Condensate Film
Real[10] hz (unit = " BTU/(hr.sq.ft.degree Rankine)");// Heat-Transfer Coefficient for the Condensate Film in BTU/(hr.sq.ft.degree Rankine)
Real hL (unit = "BTU/(hr.sq.ft.degree Rankine)"); // The convective coefficient at the plate end n BTU/(hr.sq.ft.degree Rankine)
Real mf (unit = "lbm/hr");//The amount of steam condensed in lbm/hr

Real q (unit = "BTU/hr");//The heat transfer rate in BTU/hr
Real Re;//The Reynolds Number

equation
rho_v=1/V_v;
for i in 1:10 loop
delta[i]=((4*kf*v_f*z[i]*(Tg-Tw)/3600)/(rho_f*g*hfg*(1-(rho_v/rho_f))))^(1/4);
hz[i]=(kf/delta[i]);
end for;
hL=(4/3)*hz[10]; 
mf=(hL*L*W*(Tg-Tw))/hfg;
q=mf*hfg;
Re=(4*mf/3600)/(W*rho_f*v_f);
if Re<1800 then
    //nThe film is laminar and above equations apply
else 
    //The film is not laminar and above assumption is wrong
end if;
end Ex10_1;