class Ex2_7
import Modelica. SIunits.*;
parameter ThermalConductivity k=14.4; // thermal conductivity of 304 stainless steel in  W/(m.K)from appendix table B2 
parameter Temperature T1=543; // temperature in K at point 1
parameter Temperature T2=460; // temperature in K at point 2
parameter Temperature dT=T1-T2; // temperature difference between point 1 and 2
parameter Length dz12=0.00035; // distance between thermocouple 1 and 2 in m
DensityOfHeatFlowRate qz_per_A; // heat flow calculated in W/m^2 calculated using Fourier's law
parameter Length dz56=0.0445; // distance between thermocouple 5 and 6 in m
parameter Length dz6i=0.0381; // distance between thermocouple 6 and interface in m
parameter Length dz5i=dz56+dz6i; // distance between thermocouple 5 and interface in m
parameter Temperature T5=374; // temperature in K at point 5
parameter Temperature T6=366; // temperature in K at point 6
Temperature T_ial=T5-(dz5i*(T5-T6)/dz56); // temperature of aluminium interface in K
parameter Length dzi7=0.0245; // distance between thermocouple 7 and interface in m
parameter Length dz78=0.0445; // distance between thermocouple 7 and 8 in cm
parameter Length dzi8=dzi7+dz78; // distance between thermocouple 8 and interface in cm
parameter Temperature T7=349; // temperature in K at point 7
parameter Temperature T8=337; // temperature in K at point 8
Temperature T_img; // temperature of magnesium interface in K
ThermalInsulance Rtc;// Thermal contact resistance

equation
qz_per_A=k*dT/dz12;
T_img=dzi8*(T7-T8)/dz78+T8;
Rtc=(T_ial-T_img)/qz_per_A;
end Ex2_7;