class Ex3_1
import Modelica.SIunits.*;
parameter Length OD=0.02858; // outer diameter in m
parameter Real M=8; // total number of heat-flow lanes
parameter Real N=6; // number of squares per lane
parameter Real S_L=M/N; // conduction shape factor
parameter ThermalConductivity k=0.128; // thermal conductivity in W/(m.K)
parameter Temperature T1=85 +273.15; // temperature of tube surface
parameter Temperature T2=0+273.15; // temperature of ground beneath the slab
Real q_half;//The heat flow per unit length from one half of one tube in W/m
Real q; //The total heat flow through the tube in W/m
equation
q_half=k*S_L*(T1-T2);
q=2*q_half;
end Ex3_1;
