class Ex3_5
import Modelica.Math.*;
parameter Real h (unit = "BTU/(hr.ft^2. degree R)")=1.1; // convective coefficient in BTU/(hr.ft^2. degree R)
parameter Real Tw (unit = "°F")=200;
parameter Real T_inf (unit = "°F")=68; // ambient temperature
parameter Real k (unit = "BTU/(hr.ft.degree R)")=0.47; // thermal conductivity in BTU/(hr.ft.degree R) from table B3
parameter Real D (unit = "ft")=0.25/12; // diameter in ft
Real A (unit = ""); // cross sectional area in ft^2
Real P (unit = "ft"); // perimeter in ft
parameter Real L (unit = "ft")=6/12; // length in ft
parameter Real d_zeta (unit = "ft")=1/4;
Real K (unit = "lb.ft^2");
Real mL (unit = "lb.ft");
Real [5] z=0:1.5:6;
Real[5] T (unit = "°F");
Real[5] T_e (unit = "°F");
Real[5] err;
equation
A =3.1412*D^2/4;
P =3.1412*D;
mL=L*((h*P)/(k*A))^0.5;
for i in 1:5 loop
    T[i]=T_inf+(Tw-T_inf)*(cosh(mL*(1-(z[i]/6)))/(cosh(mL)));
end for;
K=2+(mL*d_zeta)^2;
T_e[5]=T_inf+(Tw-T_inf)*(2/(K^4-4*K^2+2));
T_e[4]=T_inf+(Tw-T_inf)*(K/(K^4-4*K^2+2));
T_e[3]=T_inf+(Tw-T_inf)*((K^2-1)/(K^4-4*K^2+2));
T_e[2]=T_inf+(Tw-T_inf)*((K^3-3*K)/(K^4-4*K^2+2));
T_e[1]=200;
for i in 1:5 loop
err[i]=(T[i]-T_e[i])/T[i]*100;
end for;
end Ex3_5;