class Ex4_4
import Modelica.SIunits.*;
parameter CoefficientOfHeatTransfer hc=6;// Heat transfer Coeff
parameter Length D=0.105;//Orange Diameter
parameter ThermalConductivity k=0.431;//Thermal conducitivity of an orange
parameter SpecificHeatCapacity c=2000;//Specific Heat Capacity of an orange
parameter Density rho=998;//Density of an Orange
Volume Vs=3.1412*D^3/6;//Volume of an Orange
Area As=3.1412*D^2;//Area of an Orange
Real Bi_lumped=hc*Vs/(k*As);//Biot Number for lumped capacitance approach
ThermalDiffusivity alpha=k/(rho*c); //value of diffusivity in sq.m/s
parameter Temperature Tc=20+273.15;
parameter Temperature T_inf=23+273.15;
parameter Temperature T_i=4+273.15;
Integer n;
Real Bi_figure;
Real reciprocal_Bi;
Real dimensionless_temp;
Real Fo;//The corresponding value of Fourier Number
Time t; //The required time in seconds
Real Bi2Fo;
Real Dimensionless_HeatFlow;// The corresponding dimensionless heat flow ratio
Heat Q;//The heat transferred through the orange
algorithm
if Bi_lumped<0.1 then
    n:=0;
elseif  Bi_lumped>0.1 then
    n:=1;
end if;
if n==1 then

    Bi_figure:=hc*D/(2*k);
    reciprocal_Bi:=1/Bi_figure;
    dimensionless_temp:=(Tc-T_inf)/(T_i-T_inf);
    Fo:=1.05;
    t:=(D/2)^2*Fo/alpha;
end if;
Bi2Fo:=Bi_figure^2*Fo;
Dimensionless_HeatFlow:=0.7; // The corresponding dimensionless heat flow ratio from figure 4.8c
Q:=Dimensionless_HeatFlow*rho*c*Vs*(T_i-T_inf);

end Ex4_4;