class Ex4_7
parameter Real rho (unit = "lb/ft^3")=62.46;//Density of water
parameter Real cp (unit = "BTU/(lbm.°R)")=0.9988;//Specific heat capacity of water
parameter Real k (unit = "BTU/(hr.ft.°R)")=0.345;//Thermal conductivity of water
Real alpha (unit = "ft^2/hr");//the diffusivity at 68 degree fahrenheit in sq.ft/hr
parameter Real D (unit = "ft")=2.5/12;
parameter Real L (unit = "ft")=4.75/12;
Real Vs (unit = "cu.ft");//The volume of the can in cu.ft
Real As (unit = "sq.ft");//The surface area of the can in sq.ft
Real Lc (unit = "ft");//The characteristic length of the can in ft.
parameter Real hc=1.7;//Heat Transfer Coefficient
Real Bi;//The Biot number
parameter Real t=4;
// for the cylinder solution
Real Fo_cylinder;// The Fourier number 
Real Bi_cylinder=hc*(D/2)/k;//The biot number for cylinder
Real reciprocal_Bi_cylinder;//The reciprocal for Biot number for cylinder
parameter Real dim_T_cylinder=0.175; //The value of dimensionless temperature of cylinder from figure 4.7a at corresponding values of Fo and 1/Bi
// for the infinite plate solution
Real Fo_plate;//The Fourier number for the infinite plate
Real Bi_plate;//The Biot number for the infinite plate
Real reciprocal_Bi_plate;//The reciprocal for Biot number for infinite plate
parameter Real dim_T_plate=0.55; //The value of dimensionless temperature of infinite plate from figure 4.7a at corresponding values of Fo and 1/Bi
// Table 4. I, for the short-cylinder problem, indicates that the solution is the product of the infinite-cylinder problem (Figure 4.7) and the infinite-plate problem (Figure 4.6).
// For short cylinder problem
Real dim_T_shortcylinder;//The value of dimensionless temperature for short cylinder
parameter Real T_inf (unit = "°F")=30;
parameter Real T_i (unit = "°F")=72;
Real Tc (unit = "°F");
parameter Real dim_Tw_cylinder=0.77; //The dimensionless temperature from figure 4.7b corresponding to the value of 1/Bi and r/R=1
parameter Real dim_Tw_plate=0.65; //The dimensionless temperature from figure 4.6b corresponding to the value of 1/Bi and x/L=1
Real dim_Tw_shortcylinder;//The value of dimensionless temperature  at the wall for short cylinder
Real Tw (unit = "°F");//The wall temperature  in F
equation
alpha=k/(rho*cp);
Vs=3.1412*D^2*L/4;
As=(3.1412*D*L)+(3.1412*D^2)/2;
Lc=Vs/As;
Bi=hc*Lc/k;
Fo_cylinder=alpha*t/(D/2)^2;
reciprocal_Bi_cylinder=1/Bi_cylinder;
Fo_plate=alpha*t/(L/2)^2;
Bi_plate=hc*L/(2*k);
reciprocal_Bi_plate=1/Bi_plate;
dim_T_shortcylinder=dim_T_cylinder*dim_T_plate;
dim_Tw_shortcylinder=dim_Tw_cylinder*dim_Tw_plate;
Tc=dim_T_shortcylinder*(T_i-T_inf)+T_inf;
Tw=dim_Tw_shortcylinder*(Tc-T_inf)+T_inf;
end Ex4_7;