class Ex6_1
import Modelica.SIunits.*;
// properties of ethylene glycol at 20 degree C from appendix table C5
parameter SpecificHeatCapacity Cp=2382; //Specific heat of ethylene glycol at 20 degree C in J/(Kg K)
parameter Density rho=1.116*1000;//Density of ethylene glycol at 20 degree C in kg/m^3
parameter KinematicViscosity v=19.18e-6;//Kinematic Viscosity  of ethylene glycol at 20 degree C
parameter ThermalConductivity kf=0.249;//Thermal conductivity
parameter ThermalDiffusivity a=0.939e-7;//Thermal diffusivity of ethylene glycol at 20 degree C 
parameter Real Pr=204;//Prandtl number of ethylene glycol at 20 degree C  
// specifications of 1/2 standard type M seamless copper water tubing from appendix table F2
parameter Length OD=1.588/100; //Outer dia. of 1/2 standard type M seamless copper water tubing in metres
parameter Length ID=1.446/100;//Inner dia. of 1/2 standard type M seamless copper water tubing in metres
parameter Area A=1.642e-4;//Area of 1/2 standard type M seamless copper water tubing in m^2
parameter VolumeFlowRate Q=3.25e-6;
Velocity V;//Average flow velocity in m/s
Real Re;//Reynold's Number
Length Z_h;//The hydrodynamic length 
parameter Temperature Tbi=20+273.15; // bulk-fluid inlet temperature in kelvin
parameter HeatFlux qw=2200; // incident heat flux in W/m^2
parameter Length L=3; // Length of copper tube in m
parameter Length R=ID/2; // inner radius in m
Temperature Tbo;//The bulk-fluid outlet temperature in kelvin
// This result is based on fluid properties evaluated at 20°C. taken as a first approximation
Length Z_t;//The thermal entry length in metres
Temperature Two; // The wall temperature at outlet in kelvin
equation
V=Q/A;
Re=V*ID/v;
// since Re>he 2100, the flow regime is laminar and the hydrodynamic length can be calculated as
Z_h=0.05*ID*Re;
Tbo=Tbi+(2*qw*a*L)/(V*kf*R);
Z_t=0.05*ID*Re*Pr;
Two=Tbo+(11*qw*ID)/(48*kf);
end Ex6_1;