class Ex6_6
// air properties to be calculated at T=(72+45)/2=58.5 degree Fahrenheit
// properties at T=58.5 degree fahrenheit from appendix table D1
parameter Real p (unit = "lbm/ft^3") = 0.077; // density in lbm/ft^3 
parameter Real cp (unit = "BTU/(lbm.°R)") = 0.240; // specific heat in BTU/(lbm.°R) 
parameter Real v (unit = "ft^2/s") = 15.28e-5; // viscosity in ft^2/s 
parameter Real kf (unit = "BTU/(hr.ft.°R)") = 0.0146; // thermal conductivity in BTU/(hr.ft.°R) 
parameter Real a (unit = "ft^2/hr") = 0.776; // diffusivity in ft^2/hr 
parameter Real Pr = 0.711; // prandtl number 
parameter Real D (unit = "feet")=7/12; // diameter in ft
parameter Real L (unit = "feet")=40; // length in ft
parameter Real Tbo (unit = "°F")=72; // outlet temperature in degree Fahrenheit
parameter Real Tbi (unit = "°F")=45; // inlet temperature in degree Fahrenheit
Real A (unit = "ft^2"); // cross sectional area of duct in ft^2
// density at outlet temperature in lbm/ft^3 
parameter Real rho_o (unit = "lbm/ft^3")=0.0748;
parameter Real V (unit = "ft/s")=10; // average velocity in ft/s
Real mass_flow (unit = "lbm/sec");//The mass flow rate
// average velocity evaluated by using the average bulk temperature
Real V_avg (unit = "ft/s");//The average velocity evaluated by using the average bulk temperature in ft/s
Real Re;//The Reynolds number for the flow 
// the flow is in turbulent regime
Real q (unit = "BTU/hr");//The heat gained by air in BTU/hr
parameter Real hc (unit = "BTU/(hr. sq.ft.°R)")=1; // convection coefficient between the outside duct wall and the attic air in BTU/(hr. sq.ft.degree Rankine).
parameter Real T_inf (unit = "°F)")=105; // The temperature of attic air surrhonding the duct in degree Fahrenheit
Real hz (unit = "BTU/(hr. sq.ft.°R)"); // The local coefficient at the duct end in BTU/(hr. sq.ft.°R)
Real qw (unit = "BTU/(hr. sq.ft.°R)"); // wall flux in BTU/(hr. sq.ft)
Real Two (unit = "°F"); // The wall temperature at exit in °Fahrenheit
equation
A=3.1412*(D^2)/4;
mass_flow=rho_o*A*V;
V_avg=mass_flow/(p*A);
Re=(V_avg*D)/v;
q=mass_flow*cp*(Tbo-Tbi);
hz=(0.023*Re^(4/5)*Pr^0.4)*kf/D;
qw=(T_inf-Tbo)/((1/hc)+(1/hz));
Two=qw*(1/hz)+Tbo;
end Ex6_6;