class Ex7_6
//  Estimation of the drag due to skin friction
// properties of water at 68°F from Appendix Table C.11
parameter Real rho (unit = "lbm/cu.ft")= 62.4; // density in lbm/cu.ft
parameter Real v (unit = "sq.ft/s")= 1.083e-5; // viscosity in sq.ft/s 
parameter Real V_inf (unit = "ft/s")=5*0.5144/0.3048; // barge velocity in ft/s using conversion factors from appendix table A1
parameter Real L (unit = "ft")=20; // Length of barge in ft
Real Re_L; // Reynolds number at plate end
parameter Real Cd=0.003; //value of Cd corresponding to the Reynolds number from figure 7.11
parameter Real gc (unit = "ft/sec^2")=32.2;
parameter Real b (unit = "ft")=12; // width in ft
Real Df(unit = "lbf");//The drag force in lbf

equation
Re_L=V_inf*L/v; 
Df=(Cd*rho*V_inf^2*b*L)/(2*gc);
end Ex7_6;