class Ex8_1

// Determination of the heat transferred to the wall.
// air properties at (400+120)/2 =260 degree F = 720 degree R from Appendix Table D1
parameter Real rho (unit = "lbm/cu.ft")= 0.0551; // density in lbm/cu.ft 
parameter Real cp (unit = "BTU/(lbm-°R)")=0.2420; // specific heat BTU/(lbm-°R) 
parameter Real v (unit = "sq.ft/s")= 27.88e-5; // viscosity in sq.ft/s 
parameter Real kf (unit = "BTU/(hr.ft.°R)") = 0.01944 ; // thermal conductivity in BTU/(hr.ft.°R) 
parameter Real a (unit = "sq.ft/hr") = 1.457; // diffusivity in sq.ft/hr 
parameter Real Pr = 0.689; // Prandtl Number
parameter Real T_inf (unit = "°R")=120+460; // wall temperature in degree R
parameter Real Tw (unit = "°R")=400+460; // inside wall temperature in degree R
Real Beta;//The volumetric thermal expansion coefficient in degree R
parameter Real gc (unit = "ft/sec^2")=32.2;
parameter Real L (unit = "ft")=1; // length of wall in ft
parameter Real W (unit = "ft")=2; // width in ft
Real Gr;// Grashof Number
parameter Real temperature_slope (unit = "")=0.505; //value of temperature slope from table 8.1 corresponding to Pr=.72
Real hL (unit = "BTU/(hr.ft^2.°R)"); // The convection coefficient in BTU/(hr.ft^2.°R)
Real A (unit = "sq.ft"); // cross sectional area in sq.ft
Real qw (unit = "BTU/hr");//The heat transferred in BTU/hr

equation
Beta=1/T_inf;
Gr=(gc*Beta*(Tw-T_inf)*L^3)/v^2;
hL=(kf/L)*(4/3)*(Gr/4)^(1/4)*temperature_slope;
A=L*W;
qw=hL*A*(Tw-T_inf);//Error in the textbook
end Ex8_1;