class Ex8_2
import Modelica.SIunits.*;
import OpenModelica.Internal.*;
// Determination of heat lost thrhogh the glass per unit area
// properties of air at  22 + 273 = 295 K = 300 K(approx) and 273 K from appendix table D1
parameter Density[2] rho= {1.177, 1.295}; // density in kg/cu.m
parameter SpecificHeatCapacity[2] cp= {1005, 1005.5}; // specific heat in J/(kg*K) 
parameter KinematicViscosity[2] v= {15.68e-6, 12.59e-6}; // viscosity in sq.m/s  
parameter Real[2] Pr = {0.708, 0.713}; // Prandtl Number 
parameter ThermalConductivity[2] kf= {0.02624, 0.02426}; // thermal conductivity in W/(m.K)
parameter ThermalDiffusivity[2] a = {0.22160e-4, 0.17661e-4}; // diffusivity in sq.m/s 
parameter Temperature[2] T_inf={22+273.15, 0+273.15};// inside and outside temperature in K
CubicExpansionCoefficient[2] Beta; // volumetric thermal expansion coefficient at 295 K and 273 K in K^-1
parameter Acceleration g=9.81;//Gravitational acceleration in m/s^2
parameter Length t=0.005; // thickness of glass in m
parameter Length L=0.60; // window length in m
parameter ThermalConductivity k=0.81; // thermal conductivity of glass from appendix table B3
// for first guess
parameter Temperature[2] Tw1={18+273.15, 4+273.15};//Assumed wall temperatures in K.
Real[2] Ra1;//The Rayleigh Numbers for the 1st guess
CoefficientOfHeatTransfer[2] hL1;//The convective coefficients in W/(sq.m.K)  for the 1st guess
HeatFlux q1;//The heat flux in W/sq. m
Temperature[2] Tw_final1;//The wall temperature calculated in K for the 1st guess
Temperature[2] Tw2;//Initial wall temps for the 2nd guess
Real[2] Ra2;//The Rayleigh Numbers for the 2nd guess
CoefficientOfHeatTransfer[2] hL2;//The convective coefficients in W/(sq.m.K) for the 2nd guess
HeatFlux q2;//The heat flux in W/sq. m
Temperature[2] Tw_final2;//The wall temperature calculated in W/(sq.m.K) for the 2nd guess

algorithm
Beta:={1/(T_inf[1]), 1/(T_inf[2])}; 
for i in 1:2 loop
    Ra1[i]:=realAbs(g*Beta[i]*(Tw1[i]-T_inf[i])*L^3)/(v[i]*a[i]);
    hL1[i]:=(kf[i]/L)*(0.68+((0.67*((Ra1[i]))^(1/4))/(1+(0.492/Pr[i])^(9/16))^(4/9)));
end for;
q1:=(T_inf[1]-T_inf[2])/((1/hL1[2])+(t/k)+(1/hL1[1]));
for i in 1:2 loop
    Tw_final1[i]:=realAbs(T_inf[i]-q1*(1/hL1[i]));
    Tw2[i]:=realAbs(Tw_final1[i]); // second guess
end for;
for i in 1:2 loop
    Ra2[i]:=realAbs(g*Beta[i]*(Tw2[i]-T_inf[i])*L^3)/(v[i]*a[i]);
    hL2[i]:=(kf[i]/L)*(0.68+((0.67*((Ra2[i]))^(1/4))/(1+(0.492/Pr[i])^(9/16))^(4/9)));
end for;
q2:=(T_inf[1]-T_inf[2])/((1/hL2[2])+(t/k)+(1/hL2[1]));
for i in 1:2 loop
    Tw_final2[i]:=realAbs(T_inf[i]-q2*(1/hL2[i]));
end for;

end Ex8_2;