class Ex8_3
// determination of heat loss thrhogh the side.
parameter Real rho (unit = "lbm/cu.ft ")= 0.0735; // density in lbm/cu.ft 
parameter Real cp (unit = "BTU/(lbm-degree Rankine) ")=0.240; // specific heat in BTU/(lbm-degree Rankine) 
parameter Real v (unit = "")= 16.88e-5; // viscosity in sq.ft/s 
parameter Real kf (unit = " BTU/(hr.ft.degree Rankine) ") = 0.01516 ; // thermal conductivity in BTU/(hr.ft.degree Rankine) 
parameter Real a (unit = "sq.ft/hr") = 0.859; // diffusivity in sq.ft/hr 
parameter Real Pr = 0.708; // Prandtl Number
parameter Real Tw (unit = "degree F")=90;//Wall temperature in degree F
parameter Real T_inf (unit = "degree F")=70;
parameter Real g (unit = "ft/s^2")=32.2;//Gravitational acceleration
parameter Real L (unit = "ft")=5.5; // length in ft
parameter Real W (unit = "ft")=2+(4/12); // width in ft
Real Beta (unit="per degree Rankine"); // volumetric thermal expansion coefficient in per degree Rankine
Real Ra;//The Rayleigh Number
Real hc (unit="BTU/(hr.sq.ft.degree R)");//The value of convection coefficient in BTU/(hr.sq.ft.degree R)
Real q (unit="BTU/hr");//The heat gained in BTU/hr

equation
Beta=1/(Tw+460);
Ra=(g*Beta*(Tw-T_inf)*L^3)/(v*a/3600);
hc=(kf/L)*(0.825+((0.387*(Ra)^(1/6))/(1+(0.492/Pr)^(9/16))^(8/27)))^2;
q=hc*L*W*(Tw-T_inf);
end Ex8_3;