class Ex8_5
// determine if heat is lost lose more heat thrhogh its upper surface or one of its vertical sides
// properties of air at (100 + 60)/2 = 80°F = 540 degree R from appendix table D1
parameter Real rho (unit = "lbm/cu.ft")= 0.0735; // density in lbm/cu.ft
parameter Real cp (unit = "BTU/(lbm-degree Rankine) ")=0.240; // specific heat in BTU/(lbm-degree Rankine) 
parameter Real v (unit = "sq.ft/s")= 16.88e-5; // viscosity in sq.ft/s 
parameter Real kf (unit = "BTU/(hr.ft.degree Rankine)") = 0.01516 ; // thermal conductivity in BTU/(hr.ft.degree Rankine) 
parameter Real a (unit = "sq.ft/hr") = 0.859; // diffusivity in sq.ft/hr 
parameter Real Pr = 0.708; // Prandtl Number
parameter Real Tw (unit = "degree F")=100; // temperature of outside surface temperature of oven in degree F
parameter Real T_inf (unit = "degree F")=60; // ambient temperature  in degree F
parameter Real g (unit = "ft/s^2")=32.2;
parameter Real L (unit = "feet")=2; // length in ft
parameter Real W (unit = "feet")=2; // width in ft
Real Beta (unit = "(degree Rankine)-1"); // volumetric thermal expansion coefficient in per degree Rankine
Real Ra;//The Rayleigh Number
Real hc (unit = "BTU/(hr.sq.ft.degree R)");//The value of convection coefficient in BTU/(hr.sq.ft.degree R)
Real q1side (unit = "BTU/hr");//The heat transferred from one side in BTU/hr
// For the top, we have a heated  surface facing upward, The characteristic length is determined as follows
Real Lc (unit = "feet");//Characteristic Length in feet
Real Ra_L; // Rayleigh number based on characteristic length
Real hc_L (unit = "BTU/(hr.sq.ft.degree R)");//The convective coefficient based on characteristic length in BTU/(hr.sq.ft.degree R)
Real qtop (unit = "BTU/hr");//The heat transferred from top in BTU/hr

equation
Beta=1/(T_inf+460);
Ra=(g*Beta*(Tw-T_inf)*L^3)/(v*a/3600);
hc=(kf/L)*(0.68+(0.670*Ra^(1/4))/(1+(0.492/Pr)^(9/16))^(4/9));
q1side=hc*L*W*(Tw-T_inf);
Lc=(2*2)/(2+2+2+2);
Ra_L=(g*Beta*(Tw-T_inf)*Lc^3)/(v*a/3600);
hc_L=(kf/Lc)*0.54*(Ra_L)^(1/4);
qtop=hc_L*L*W*(Tw-T_inf);
//if qtop>q1side then
  // The top transfers heat at a higher rate
//elseif qtop<q1side
  //The side transfers heat at a higher rate
//else 
  //The top and side transfer heat at equal rates
//end if;
end Ex8_5;