model Ex10_1
Real q2(unit="kJ/Kg")"Second Heat Transfer";
Real q1(unit="kJ/kg") "Heat Transfer  Process 1";
Real wrev(unit="kJ/kg") "Revesible  Work";

/*Values of Entropy and Enthalpy of different streams are calculated from Steam Tables*/
parameter Real si(unit="kJ/kgK")= 0.5705 " Entropy at Inlet";
parameter Real hi(unit="kJ/kg")= 171.95 "Enthalpy at inlet";
parameter Real he(unit="kJ/kg")= 765.24 "Enthalpy at Exit";
parameter Real se(unit="kJ/kgK")= 2.1341 " Entropy at Outlet";

parameter Real mdot(unit="kg/s")= 5 "Mass Flowrate of water";
parameter Real qadd(unit="kw")= 900 "Heat Added";
parameter Real To(unit="K")= 298.2 "Standard Temperature";
parameter Real T1(unit="K")= 100+273.2 " Temperature at stage 1";
parameter Real T2(unit="K")= 200+273.2 "Temperature at stage 2";

 
  equation
  q1=qadd/mdot;
  q2=he-hi-q1;
 
wrev=(To*(se-si))-(he-hi)+(q1*(1-(To/T1)))+(q2*(1-(To/T2))); 
end Ex10_1;
