model Ex10_4
Real m1(unit="kg") "Initial Mass";
Real m2(unit="kg") "Final Mass";
Real v2(unit="m3/kg") "Final Specific Volume";
Real x2 "Dryness Fraction";
Real S12gen(unit="kJ/K") "Entropy Generated for Process";
Real Icv(unit="kJ") "Irreversibilty";
Real n"Calculation of m2(u2-hi)/*Defined for making calculation looks easy*/";
Real mi(unit="kg") "Mass Remained in tank";


/*From Ammonia Tables,The initial and line state properties are*/
parameter Real v1(unit="m3/kg")= 0.6995 " Specific Volume";
parameter Real u1(unit="kJ/kg")= 1369.5 "Initial Internal Energy ";
parameter Real s1(unit="kJ/kgK")= 5.927 "Initial Entropy";
parameter Real hi(unit="kJ/kg")= 134.41 " Enthalpy associated with flowing sream";
parameter Real V(unit="m3")= 1 "Volume of Rigid Tank";
parameter Real v2f(unit="m3/kg")= 0.001534 "Specific Volume of liquid";
parameter Real v2fg(unit="K")= 0.41684 "Specific Volume of Vapor";
parameter Real u2f(unit="kJ/kg")= 133.964 "Internal of saturated liquid";
parameter Real u2fg(unit="kJ/kg")= 1175.257 "Internal energy of saturated Vapor";
parameter Real s2(unit="kJ/kgK")= 0.5762 " Entropy at Condition 2";
parameter Real si(unit="kJ/kgK")= 0.5408 "Entropy of Ammonia in tank";
parameter Real To1(unit="K")=293.15 "Ambient Temperature";

 
  equation
  m1=V/v1;/*Initial Mass*/
  /* m2(u2-hi)=m1(u1-hi)*/
   n=m1*(u1-hi);
     /* m2=V/v2; v2=v2f+x2*v2fg */
     /* Putting Above Equation and finding values of x2 */
   x2 =(n*v2f-(u2f-hi))/(u2fg-(n*v2fg));
  v2=v2f+x2*v2fg;
 m2=V/v2;
 mi=m2-m1;
 S12gen=(m2*s2)-(m1*s1)-(mi*si);
 Icv=To1*S12gen;
end Ex10_4;
