model Ex10_8

Real sdotgen(unit="W/K") "Exergy Flux Generated";
Real phid(unit="W") "Exergy Flux Destroyed";
Real phit(unit="W") "Transfer Out Exergy Flux";

parameter Real To(unit="K")       =298.15 "Standard Temperature";
parameter Real Tsurf(unit="K")    =1000 "Surface Temperature";
parameter Real Qdotout(unit"W")   = 500 " Heat Input";

 equation
 
 //Calculations of Flow Exergy
sdotgen=Qdotout/Tsurf;
phid=To*sdotgen;
phit=(1-(To/Tsurf))*Qdotout;

/* The Heating Element Receives 500 W of exergy Flux, destroys 149 W, and gives out the balance of 350.9 W wit the heat transfer at 1000K*/

/*Anwer is very slightly different because of higher accuracy*/

end Ex10_8;
