model Ex11_5
Real wp(unit="kJ/kg") "Work into the pump per kg of fluid flowing";
Real wt(unit="kJ/kg") "Turbine Work";
Real wnet(unit="kJ/kg") "Net Work";
Real qH(unit="kJ/kg")   "Heat Transferred to Boiler";
Real x6s"Dryness Fraction at state 6";
Real h6s(unit="kJ/kg") "Enthalpy at state 6 isentropic";
Real etaTh "Thermal Efficiency of cycle";

parameter Real etaT=0.86 "Tutbine Efficiency";
parameter Real etaP=0.80 "Pump Efficiency";
parameter Real v(unit="m3/kg")    =0.001009 "Specific Volume";
parameter Real h4(unit="kJ/kg")   =3213.6 "Enthalpy at state 4";
parameter Real h3(unit="kJ/kg")   =171.8 "Enthalpy at state 3 ";
parameter Real P2(unit="kPa")     =5000 "Pressureat state 2";
parameter Real P1(unit="kPa")     =10 "Pressure at state 1";
parameter Real h5(unit="kJ/kg")   =3169.5 "Enthalpy at state 5 ";
parameter Real s6s(unit="kJ/kgK")  =6.7235 "Entropy at state 5 equal to state 6";
parameter Real s6sf(unit="kJ/kgK") =0.6493 "Entropy of saturated liquid at sate 5/6";
parameter Real s6sfg(unit="kJ/kgK")=7.50009 "Entropy at Vaporization at state 6";
parameter Real h6sf(unit="kJ/kg")  =191.8 "Enthalpy of saturated liquid at sate 6";
parameter Real h6sfg(unit="kJ/kg")  =2392.8 "Enthalpy at Vaporization at state 6";

 equation
 
 //Calculation of Dryness Fraction
 x6s=(s6s-s6sf)/s6sfg;
 h6s=h6sf+(x6s*h6sfg);
 
 // Turbine Work
 wt= etaT*(h5-h6s); 
 
 // Pump Work
 wp=v*(P2-P1)/etaP;
  
  // Net Work
 wnet=wt-wp;
 
 // Energy Transferred to Boiler 
 qH=(h4-h3);

 //Thermal Efficieny
 etaTh=wnet/qH;

/* Thermal Efficiency comes out to be 29.12% */
end Ex11_5;
