model Ex11_7
Real wc(unit="kJ/kg") "Compressor Work";
Real qL(unit="kJ/kg")   "Heat Transferred to Boiler";
Real Beta "Coefficient of Performance";

parameter Real q(unit="kJ/kg")=-4 "Heat Transfer during compression";
parameter Real h1(unit="kJ/kg")   =394.9 "Enthalpy  of R-134a at state 1 from table at given temperature";
parameter Real h2(unit="kJ/kg")   =480.9 "Enthalpy at state 2 from table at given temperature";
parameter Real h7(unit="kJ/kg")   =256.5 "Enthalpy at state 7 =h5==h6 from table at given temperature";
parameter Real h8(unit="kJ/kg")    =386.6 "Enthalpy at state 8  from table at given temperature";

 equation
 
  // Compressor Work
 wc= h2-h1-q; 
 
 // Energy Transferred to Evaporator 
 qL=h8-h7;

 //COP
 Beta=qL/wc;
 
end Ex11_7;
