model Ex12_3
Real etaTh "Thermal Eficiency";
Real qH "Heat Transferred";

parameter Real wnet(unit="kJ/kg")=395.2 "From Previous Sum";
parameter Real Cp(unit="kJ/kgK")=1.004 "Specific Heat of air";
parameter Real T3(unit="K")=1373.2 "Temperature at state 3 from previous example";
parameter Real T4(unit="K")=710.8 "Temperature at state 4 from previous example";

equation
qH=Cp*(T3-T4); /*T4=Tx*/
etaTh=wnet/qH;
end Ex12_3;
