model Ex12_6
Real qL(unit="kL/kg") "Heat supplied";
Real mdot(unit="kg/s")"Rate of Air Inlet";

parameter Real QdotL(unit="kW")=1 "Refrigeration Capacity";
parameter Real Cp(unit="kJ/kgK")=1.004 "Specific Heat of Air";
parameter Real T1(unit="K")= 253.2 "Inlet Air Temperature at Compressor";
parameter Real T4(unit="
K")= 181.9 "Temperature at low temperature heat exchanger";

equation
qL=Cp*(T1-T4);
mdot=QdotL/qL;

end Ex12_6;
