model Ex12_8

Real T2(unit="K")   "Temperatute at state 2";
Real T3(unit="K")   "Temperature at state 3";
Real T4(unit="K")   "Pressure at state 4";
Real P2(unit="MPa") "Pressure at state 2";
Real P3(unit="MPa") "Pressure at state 3";
Real P4(unit="MPa") "Pressure at state 4";
Real v3(unit="m3/kg")"Specific Volume at state 3";
Real etaTh "The Thermal Efficiency";
Real q41(unit="kJ/kg")"Heat Transfer in process 4-1";
Real wnet(unit="kJ/kg")"Net Work";
Real mep(unit="kPa") "Mean effective Pressure";

parameter Real T1(unit="K")=288.2 "Inlet Temperature";
parameter Real P1(unit="MPa")=0.1 "Pressure at Compression stroke";
parameter Real Cv(unit="kJ/kgK")=0.717 "Specific heat at constant volume";
parameter Real Cp(unit="kJ/kgK")=1.004 "Specific heat at constant Presure";
parameter Real v1(unit="m3/kg")=0.827 "Specific Volume at state 1";
parameter Real v2(unit="m3/kg")=0.04135 "Specific Volume at state 2";
parameter Real rv=20 "Compression ratio";
parameter Real k=1.4 "Index ofthe   process";
parameter Real q23(unit="kJ/kg")=1800 "Heat Transfer to the air per cycle";


equation

//Calculations of Pressure and Temperature attend of each process
T2=T1*(rv^(k-1));
T3=(q23/Cp)+T2;
v3=(T3/T2)*v2;
P2=P1*(rv^k);
P3=(T3/T2)*P2;
T4=T3/((v1/v3)^(k-1));
P4=P3/(rv^k);

//Heat Rejected
q41=-Cv*(T1-T4); /* Negative sign sows heat rejection */

// Thermal Efficiency
etaTh=(1-(1/(rv^(k-1))));

//Net Work
wnet=q23-q41;

// Mean Effective Pressure
mep=wnet/(v1-v2);

end Ex12_8; 
