model Ex14_5

/*This Question is based on using Genreralized Chart */
Real h11a(unit="kJ/kg")"From generalized Chart enthalpy Change at constant Temperature";
Real h22a(unit="kJ/kg")"From generalized Chart enthalpy Change at constant Temperature";
Real h12a(unit="kJ/kg")"From generalized Chart enthalpy Change at constant Temperature";

Real Tr2"Final Reduced Temperature";
Real dh(unit="kJ/kg") "Enthalpy Change: h1-h2";

/* Using Values from Table A.2 */
parameter Real P1(unit="MPa")=20 "Initial Pressure";
parameter Real T1(unit="K")=203.2 "Initial Temperature";
parameter Real Tc=126.2 "Critical Temperature";
parameter Real Ta=146 "Assumed Temperature";
parameter Real P2(unit="MPa")=2 "Final Pressure";
parameter Real Pr1=5.9 " Initial Reduced Pressure";
parameter Real Pr2=0.59 " Finial Reduced Pressure";
parameter Real Tr1=1.61 "Initial Reduced Temperature";
parameter Real Cpo(unit="kJ/kgK")=1.0416 "Gas Constant";
parameter Real R(unit="kJ/kgK")=0.2968 "Gas Constant";

equation
h11a=2.1*R*Tc;
Tr2=Ta/Tc;
h12a=Cpo*(T1-Ta);
h22a=0.5*R*Tc;
dh=-(h11a)+(h12a)+(h22a);

/* The value of dh comes very near to zero therefore assumed temperature is correct */
/* From The Thermodynamics Tables for Nitrogen,Table B.6 The Final Temperature is approximately 146 K*/

end Ex14_5;
