model Ex15_7

Real Tavg(unit="K")"Average Temperature";
Real Cpo(unit="kJ/kgK")"Specific Heat at average temperature";
Real theta(unit="K")"Average Temperature parameter";
Real hTP(unit="kJ/kmol")"Enthalpy of Water";
Real dhb(unit="kJ/kmol")"Difference in enthalpy brtween given state and the enthalpy of ideal gas";
parameter Real T(unit="K")=298.15"Standard Temperature";
parameter Real T1(unit="K")=300+273.15"Standard Temperature";
parameter Real hfo(unit="kJ/kmol")= -241826 "Enthalpy of Formation from appendix";
parameter Real M(unit="kg")=18.015"Molecular weight water";

/*For Part 2*/
Real hTP2(unit="kJ/kmol")"Enthalpy of Water using A.9";
parameter Real dhb2(unit="kJ/kmol")=9539"Difference in enthalpy brtween given state and the enthalpy of ideal gas";
/*For Part 3*/
Real hTP3(unit="kJ/kmol")"Using the steam tables";
parameter Real dhb3(unit="kJ/kmol")=7752"Difference in enthalpy brtween given state and the enthalpy of ideal gas";

/*For Part 4*/
Real hTP4(unit="kJ/kmol")"Using the generalized charts";
Real h22a(unit="kJ/kmol")"using Generalized charts";
parameter Real h11a(unit="kJ/mol")=0 "Ideal gas Reference";
parameter Real h21a(unit="kJ/mol")=9539;
parameter Real R(unit="kJ/molK")=8.314"Gas Constant";
parameter Real Tc(unit="K")=647.3 "Critical Temperature";

equation

// Part 1
Tavg=(T+T1)/2;
theta=Tavg/1000;
Cpo=1.79+(0.107*theta)+(0.586*(theta^2))-(0.20*(theta^3));
dhb=M*Cpo*(T1-T);
hTP=hfo+dhb;

// Part 2
hTP2=hfo+dhb2;

// Part 3
/*Using Gas Reference*/
hTP3=hfo+dhb3;

// Part 4
h22a=0.21*R*Tc;
hTP4=hfo-(h22a)+(h21a)+(h11a);

end Ex15_7;
