model Ex15_8
/*The combustion Equation
C8H18(L)+4(12.5)O2+4(12.5)(376)N2 ====> 8CO2+9H2O+37.5O2+188.0N2
*/

Real Qcv(unit="kJ/kmol fuel")"Heat Transfer from Engine per kmol of fuel";
Real Wcv(unit="kJ/kmol fuel")"Power";
Real nhp(unit="kJ/kmol fuel")"Enthalpy of Product Formation";

parameter Real hfo(unit="kJ/kmol")=-250105 "Enthalpy of the reactants";
parameter Real fc(unit="kg/kg")=1000/0.25 " Fuel Consumption: 0.25 per Megawatt output";
parameter Real P(unit="kg/kmol")=114.23"Fuel used";
parameter Real nCO2=8,nH2O=9,nO2=37.5,nN2=188"Coefficeints of Products";
parameter Real hfoCO2=-393522,dhCO2=28030,hfoH2O=-241826,dhH2O=21937,hfoO2=0,dhO2=19241,hfoN2=0,dhN2=18225 "Standard Enthalpy of Formation of Products";

equation
Wcv=fc*P;
nhp=nCO2*(hfoCO2+dhCO2)+nO2*(hfoO2+dhO2)+nN2*(hfoN2+dhN2)+nH2O*(hfoH2O+dhH2O);
Qcv=Wcv-hfo+nhp;

/*Answer is slightly different because of higher accuracy*/

end Ex15_8;
