model Ex17_1

Real To(unit="K")"Isentropic Stagnation Temperature";
Real Po(unit="kPa")"Isentropic Stagnation Pressure";

parameter Real P(unit="kPa")=150"Pressure";
parameter Real T(unit="K")=300"Temperature";
parameter Real V(unit="m/s")=200"Velocity";
parameter Real Cpo(unit="kJ/kg.K")=1.004"Specific Heat of Air";
parameter Real K=0.286"Index of Isentropic equation";

equation

To=V^2/(2*1000*Cpo)+T;
Po=(To/T)^(1/0.286)*P;


end Ex17_1;
