model Ex2_2

Real v(unit="m3/kg")"Overall specific volume";
Real rho(unit="kg/m3")"Density";

Real mgr(unit="kg")"Mass of Granite";
Real msn(unit="kg")"Mass of Sand";
Real mw(unit="kg")"Mass of Water";
Real mair(unit="kg")"Mass of air";

Real mtot(unit="kg")"Total Mass";

parameter Real rhog(unit="kg/m3")=2750 "Density of Granite";
parameter Real rhos(unit="kg/m3")=1500 "Density of Sand";
parameter Real rhow(unit="kg/m3")=997 "Density of Water";
parameter Real rhoa(unit="kg/m3")=1.15 "Density of Granite";

parameter Real Vg(unit="m3")=0.12 "Volume of Granite";
parameter Real Vs(unit="m3")=0.15 "Volume of Sand";
parameter Real Vw(unit="m3")=0.2 "Volume of Water";
parameter Real Va(unit="m3")=0.53 "Volume of Air";
parameter Real Vtot(unit="m3")=1" Total Volume";

equation
//mass of granite
mgr=rhog*Vg;

//mass of sand
msn=rhos*Vs;

//mass of water
mw=rhow*Vw;

//mass of air
mair=rhoa*Va;

// Total Mass
mtot=mgr+msn+mw+mair;

// Specific Volume
v=Vtot/mtot;

// Density
rho=mtot/Vtot;


end Ex2_2;
