model Ex2_6
Real dPg(unit="kPa")"Pressure Difference due to Gravity for Gasoline";
Real dPr(unit="kPa")"Pressure Difference due to Gravity for R-134a";

Real Pg(unit="kPa")"Total Pressure for Gasoline";
Real PR(unit="kPa")"Total Pressure for GR-134a";

parameter Real rhog(unit="kg/m3")=750"Density of gasoline",rhoR(unit="kg/m3")=1206"Density of R-134a",g(unit="m/s2")=9.8"Acceleration due to gravity",H(unit="m")=7.5"Height of Storage Tank";
parameter Real Ptopg(unit="kPa")=101"Pressure at Top Surface for Gasoline";
parameter Real PtopR(unit="kPa")=1000"Pressure at Top Surface for R-134a";

equation
dPg=rhog*g*H/1000;
dPr=rhoR*g*H/1000;
Pg=Ptopg+dPg;
PR=PtopR+dPr;
end Ex2_6;
