model Ex3_6
  Real mliq(start = 0, unit = "m");
  Real mvap(start = 0, unit = "m/s");
  Real mtotal(start = 0, unit = "m/s");
  Real x(start = 0, unit = "m/s");
  
  parameter Real Vliq(unit = "m3") = 0.1 "Volume of saturated liquid";
  parameter Real Vvap(unit = "m3") = 0.9 "Volume of saturated vapor";
  parameter Real Vf(unit = "m3") =  0.000843"Specific Volume of liquid";
  parameter Real Vg(unit = "m3") = 0.02671" Specific Volume of vapor";
    
equation
  /* Equations of motion */
  mliq = Vliq/Vf;
  mvap=Vvap/Vg;
  mtotal=mliq+mvap;
  x=mvap/mtotal;
  
end Ex3_6;
