model Ex4_1

Real W12( unit = "kJ")"Work Done by the system";
Real W12b( unit = "kJ")"Work Done by the system in part B";
Real W12c( unit = "kJ")"Work Done by the system in part C";
Real P2(unit = "kPa") " Final Pressure";

  parameter Real V1(unit = "m3")=0.04 "Initial Volume";
  parameter Real V2(unit = "m3") = 0.1 "Final Volume";
  parameter Real P1(unit = "kPa")=200 " Initial Pressure";
  parameter Real n=1.3 "for plytropic process n=3";
  
  
equation
  
W12=P1*(V2-V1); /*Part A*/
W12b=P1*V1*log(V2/V1); /*Part B*/

P2=P1*(V1/V2)^1.3;

W12c=((P2*V2)-(P1*V1))/(1-n); /* Part C*/

/*Part D: Work done is zero for constant volume process*/

end Ex4_1;
