model Ex5_1

Real H( unit = "m") "Height";
Real V(unit = "m/s") "Velocity";
  
  parameter Real KE( unit = "KJ")= 400 "Kinetic Energy";
  parameter Real m( unit = "kg")= 1100 "Mass of Car";
  parameter Real g(unit="m/s2")=9.807 "Acceleration due to gravity";
  
equation
/*PE=mGH; KE=1/2mV^2*/ 

V=sqrt(2*KE*1000/m); /*Multiplied by 1000 for unit balance*/
H=div(KE*1000,m*g); /*Multiplied by 1000 for unit balance*/

end Ex5_1;
