model Ex5_7

Real m(unit = "kg")"Mass";
Real v2(unit="m3/kg")"Specific Volume at condition 2";
Real Q12(unit="kJ") "Heat Transferred";
Real W12b(unit="kJ") "Work done during the process 1 to 2 for Part b";



parameter Real x1=1 "Dryness fraction";
parameter Real P1(unit="kPa")=573 "Pressure";
parameter Real v1(unit="m3/kg")=0.03606 "Specific Volume";
parameter Real u1(unit="m3/kg")=389.2 "Specific Internal energy";

/*From Table following dataare obtained*/
parameter Real P2(unit="kPa")=163 "Pressure at condition 2";
parameter Real u2(unit="kJ/kg")=395.8 "Specific internal energy at condition 2";
parameter Real u2b(unit="kJ/kg")=383.4 "Specific internal energy at condition 2 for part B ";

parameter Real V1(unit="m3")=0.010 "Volume";
parameter Real V2(unit="m3")=0.040 "Volume at condition 2";
parameter Real W12(unit="kJ")=8 "Work done during the process 1 to 2";

equation

// Part A
m=V1/v1;
v2=v1*div(V2,V1);
Q12=m*(u2-u1)+W12;

// Part B
W12b=m*(u1-u2b);


end Ex5_7;
