model Ex5_9

Real m(unit="kg") "Mass of Nitrogen";
Real Q12(unit="kJ") "Amount of Heat Transfer";

parameter Real P(unit="kPa")= 150 "Pressure of the system";
parameter Real V(unit="m3")= 0.1 "Volume of cylinder";
parameter Real R(unit="kJ/kg.K")= 0.298"Gas Constant";
parameter Real T1(unit="K")= 298.15 " Initial Temperatue of the system";
parameter Real T2(unit="K")= 150+273 "Final Temperature of the system";
parameter Real W12(unit="kJ")= -20 "Work done on the nitrogen";
parameter Real Cv(unit="kJ/kg.K")= 0.745 "Specific Heat at constant Volume";

 
    
  equation
    m = P * V / (R * T1);
    Q12 = m * Cv * (T2 - T1) + W12;
  


end Ex5_9;
