model Ex6_7

/*Assumptions: Velocity at inlet is 0 and q is also 0*/

Real w(unit = "kJ/kg") "Power";
Real mdot(unit="kg/s")"Mass flow rate";
Real q(unit="kJ/kg")"enthalpy change or energy flow per unit mass ";
Real Qdotcv(unit ="kW") "Heat Transfer rate in aafetr cooler ";

   /*Values of Enthalpies are take from Steam Tables at Given T and P As given below*/
   
  parameter Real h1( unit = "kJ/kg")= 198.0 "Enthalpy at inlet of compressor";
  parameter Real h2( unit = "kJ/kg")= 401.52 "Enthalpy at Exit of compressor ";
  parameter Real h3( unit = "kJ/kg")= 257.9 "Enthalpy at Exit of after cooler ";
  parameter Real WdotC(unit ="kW")= -50 "Power input to the compressor";
   
   
  parameter Real V1(unit = "m/s")= 0 "Velocity of Steam at Inlet";
  parameter Real V2(unit = "m/s")= 25 "Velocity of Steam at Exit";  
    
equation

/*From the First law for open System*/
w=-(h2-h1+(V2^2/(2*1000))); 
/*Divided by thousand for unit balance*/

mdot=WdotC/w;

q=h3-h2; /*Assumption no chnge in K.E. therefore V2 and V3 reamins the same*/

Qdotcv=-mdot*q;



end Ex6_7;
