model Ex8_2

Real Q12(unit="kJ") "Heat Transfer for step 1 to 2";
Real W12(unit="kJ") "Work Transfer for step 1 to 2";
Real m(unit="kg")" Mass calculated from V/v1 ";

/* From Continuity equation mass flow remains same*/

/*Following values are obtaoned from Table B.4.1 and B.4.2*/
parameter Real u1(unit="kJ/kg")= 87.94  "Internal Energy at Postion 1";
parameter Real s1(unit="kJ/kg.K")= 0.3357 "Entropy at Postion 1 ";
parameter Real u2(unit="kJ/kg")= 276.44  "Internal Energy at Postion 2";
parameter Real s2(unit="kJ/kg.K")= 1.2108 "Entropy at Postion 2 ";
parameter Real V(unit="m3")= 0.001 " Volume";
parameter Real v1(unit="m3/kg")= 0.000923 " Specific Volume";
parameter Real T(unit="K")=20+273 " Volume";


equation
m=V/v1;
Q12=m*T*(s2-s1); /*From Energy Equation*/
W12=m*(u1-u2)+Q12 ;/*As per sign convention*/

end Ex8_2;
