model Ex9_9

Real Qdotcv(unit="kW") "Heat Transferred";
Real sdotgen(unit="kW/K") "Rate of Entropy Generation";

/*Values of Entropy and Enthalpy of different straems are calculated from B.1.3 and B.a.2*/
parameter Real si(unit="kJ/kgK")= 1.0272 "Entropy at State 1";
parameter Real hi(unit="kJ/kg")= 280.6 "Enthalpy at inlet";
parameter Real he(unit="kJ/kg")= 307.8 "Enthalpy at Outlet";
parameter Real se(unit="kJ/kgK")= 1.0140 "Outlet Entropy";
parameter Real mdot(unit="kg/s")=0.08 "Flow rate of Refrigerant through Compressor";
parameter Real Wdotcv(unit="kW")= 3 "Power Input";
parameter Real To(unit="K")= 303.2 "Ambient Temperature";


 
  equation
Qdotcv=mdot*(he-hi)-Wdotcv;
sdotgen=mdot*(se-si)-Qdotcv/To;
end Ex9_9;
